
#delimit ;
use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\LDS_30day(CMS)( 9 Sep 2024)16_46_47", replace;

gen eps = 1;
gen rural = rural_add_on > 0 & rural_add_on ~= .;
gen hipps_short = substr(hipps,1,4);


******** Creates summary file by HIPPS categories ;
gen     clin = "";
replace clin = "A - MMTA Other"                 if substr(hipps,2,1) == "A"; 
replace clin = "B - Neuro Rehab"                if substr(hipps,2,1) == "B";
replace clin = "C - Wounds"                     if substr(hipps,2,1) == "C";
replace clin = "D - Complex Nursing Interv"     if substr(hipps,2,1) == "D";
replace clin = "E - MS Rehab"                   if substr(hipps,2,1) == "E";
replace clin = "F – Behavioral Health"          if substr(hipps,2,1) == "F";
replace clin = "G – MMTA Surgical Aftercare"    if substr(hipps,2,1) == "G";
replace clin = "H – MMTA Cardiac & Circulatory" if substr(hipps,2,1) == "H";
replace clin = "I – MMTA Endocrine"             if substr(hipps,2,1) == "I";
replace clin = "J – MMTA GI/GU"                 if substr(hipps,2,1) == "J";
replace clin = "K – MMTA Infectious Disease"    if substr(hipps,2,1) == "K";
replace clin = "L – MMTA Respiratory"           if substr(hipps,2,1) == "L";

gen     func = "";
replace func = "A - Low"    if substr(hipps,3,1) == "A"; 
replace func = "B - Medium" if substr(hipps,3,1) == "B";
replace func = "C - High"   if substr(hipps,3,1) == "C";

gen     source = "";
replace source = "Community"     if substr(hipps,1,1) == "1" | substr(hipps,1,1) == "3";
replace source = "Institutional" if substr(hipps,1,1) == "2" | substr(hipps,1,1) == "4";

gen     timing = "";
replace timing = "Early" if substr(hipps,1,1) == "1" | substr(hipps,1,1) == "2";
replace timing = "Late"  if substr(hipps,1,1) == "3" | substr(hipps,1,1) == "4";

gen     comorbid = "";
replace comorbid = "1 - None" if substr(hipps,4,1) == "1";
replace comorbid = "2 - Low"  if substr(hipps,4,1) == "2";
replace comorbid = "3 - High" if substr(hipps,4,1) == "3";
mdesc clin func source timing comorbid;

#delimit ;

preserve;
gen all = 1;
collapse (sum) eps (mean) rural pmt_amt pmt_amt_out outlier pep lupa weight *cvis* *cmin*, by(all);
summ eps;
gen pcnt = eps/`r(sum)';
gen clin     = "All";
gen func     = "All";
gen source   = "All";
gen timing   = "All";
gen comorbid = "All";
tempfile temp_all;
save   "`temp_all'";
restore;


preserve;
collapse (sum) eps (mean) rural pmt_amt pmt_amt_out outlier pep lupa weight *cvis* *cmin*, by(clin);
summ eps;
gen pcnt = eps/`r(sum)';
*gen clin     = "All";
gen func     = "All";
gen source   = "All";
gen timing   = "All";
gen comorbid = "All";
tempfile temp_clin;
save   "`temp_clin'";
restore;

preserve;
collapse (sum) eps (mean) rural pmt_amt pmt_amt_out outlier pep lupa weight *cvis* *cmin*, by(func);
summ eps;
gen pcnt = eps/`r(sum)';
gen clin     = "All";
*gen func     = "All";
gen source   = "All";
gen timing   = "All";
gen comorbid = "All";
tempfile temp_func;
save   "`temp_func'";
restore;

preserve;
collapse (sum) eps (mean) rural pmt_amt pmt_amt_out outlier pep lupa weight *cvis* *cmin*, by(source);
summ eps;
gen pcnt = eps/`r(sum)';
gen clin     = "All";
gen func     = "All";
*gen source   = "All";
gen timing   = "All";
gen comorbid = "All";
tempfile temp_source;
save   "`temp_source'";
restore;

preserve;
collapse (sum) eps (mean) rural pmt_amt pmt_amt_out outlier pep lupa weight *cvis* *cmin*, by(timing);
summ eps;
gen pcnt = eps/`r(sum)';
gen clin     = "All";
gen func     = "All";
gen source   = "All";
*gen timing   = "All";
gen comorbid = "All";
tempfile temp_timing;
save   "`temp_timing'";
restore;	

preserve;
collapse (sum) eps (mean) rural pmt_amt pmt_amt_out outlier pep lupa weight *cvis* *cmin*, by(comorbid);
summ eps;
gen pcnt = eps/`r(sum)';
gen clin     = "All";
gen func     = "All";
gen source   = "All";
gen timing   = "All";
*gen comorbid = "All";
tempfile temp_comorbid;
save   "`temp_comorbid'";
	


/*;
preserve;
replace clin     = "All";
replace func     = "All";
replace source   = "All";
replace timing   = "All";
replace comorbid = "All";
collapse (sum) eps (mean) rural pmt_amt pmt_amt_out outlier pep lupa weight *cvis* *cmin*, by(ther clin func);
summ eps;
gen pcnt = eps/`r(sum)';
*/;

use "`temp_all'", replace;
append using "`temp_clin'";
append using "`temp_func'";
append using "`temp_source'";
append using "`temp_timing'";
append using "`temp_comorbid'";
order clin func source timing comorbid eps pcnt rural pmt_amt pmt_amt_out outlier pep lupa weight phy_cvis occ_cvis spc_cvis skn_cvis mss_cvis aid_cvis phy_cmin occ_cmin spc_cmin skn_cmin mss_cmin aid_cmin ;


list *, sep(0) clean noobs;

export excel     using "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Plotzke\Recalibration (2025 Rule)\LDS\Public Facing 30-Day - Final - Summary(`date3')`date'_`date1'_`date2'.xlsx", firstrow(variables) replace;
datasig;
restore;